﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for DeliveryReport.xaml
    /// </summary>
    public partial class DeliveryReport : Page
    {
        public DeliveryReport()
        {
            InitializeComponent();
            LoadReport();
        }

        private void LoadReport()
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
                {
                    List<Products> ProductList = ProductsBL.GetList(Guid.Empty, string.Empty);
                    ProductList = (from pb in ProductList
                                   where pb.IsActive
                                   orderby pb.ActualStock ascending
                                   select pb).ToList<Products>();
                    gvLowStockReport.Dispatcher.BeginInvoke(new Action(() => gvLowStockReport.ItemsSource = ProductList.Take(20)));
                });
        }
    }
}
